<?php

/**psr-4 */
require_once "vendor/autoload.php";

use App\Libreria\Conexion;
use App\Models\Carrusel;

$connecion = new Conexion();

$directorio = 'public/galeria/';
if (!empty($_POST['editar'])) {
    $carrusel = Carrusel::find($_POST['id_carrusel']);
    $info = new SplFileInfo($_FILES['carrusel']['name']);
    $filename = $carrusel->id . 'carrusel.' . strtolower($info->getExtension());
    $source = $_FILES["carrusel"]["tmp_name"];

    if (strtolower($info->getExtension()) == 'png' || strtolower($info->getExtension()) == 'jpg') {
        //Validamos si la ruta de destino existe, en caso de no existir la creamos
        if (!file_exists($directorio)) {
            mkdir($directorio, 0777) or die("No se puede crear el directorio de extracci&oacute;n");
        }

        $dir = opendir($directorio);
        $target_path = $directorio . $filename;
        unlink($directorio . $carrusel->url);

        if (move_uploaded_file($source, $target_path)) {
            $connecion->connection()->getPdo()->beginTransaction();
            try {
                if ($carrusel) {
                    $carrusel->url = $filename;
                    $carrusel->save();
                    $_SESSION['message_success'] = "El archivo $filename se ha almacenado en forma exitosa.";
                } else {
                    throw new Exception("Error al buscar el carrusel", 1);
                    $_SESSION['message_success'] = "error no identificado";
                }

                $connecion->connection()->getPdo()->commit();
            } catch (\Throwable $th) {
                $connecion->connection()->getPdo()->rollBack();
                $_SESSION['message_error'] = "Ha ocurrido un error, por favor inténtelo de nuevo.";
                unlink($directorio . $filename);
            }
        } else {
            $_SESSION['message_error'] = "Ha ocurrido un error, por favor inténtelo de nuevo.";
        }
        closedir($dir);
    } else {
        $_SESSION['message_error'] = 'La extension del archivo es invalido';
    }
}

if (!empty($_POST['nuevo'])) {
    $info = new SplFileInfo($_FILES['carrusel']['name']);
    $source = $_FILES["carrusel"]["tmp_name"];

    if (strtolower($info->getExtension()) == 'png' || strtolower($info->getExtension()) == 'jpg') {
        //Validamos si la ruta de destino existe, en caso de no existir la creamos
        if (!file_exists($directorio)) {
            mkdir($directorio, 0777) or die("No se puede crear el directorio de extracci&oacute;n");
        }

        $dir = opendir($directorio);
        
        $carrusel = new Carrusel;
        $carrusel->nombre = 'CARRUSEL';
        
        $carrusel->save();
        
        $filename = $carrusel->id . 'carrusel.' . $info->getExtension();
        $target_path = $directorio . $filename;

        $carrusel->url = $filename;
        $carrusel->save();

        if (move_uploaded_file($source, $target_path)) {
            $_SESSION['message_success'] = "El archivo $filename se ha almacenado en forma exitosa.";
        } else {
            $_SESSION['message_error'] = "Ha ocurrido un error, por favor inténtelo de nuevo.";
        }
        closedir($dir);
    } else {
        $_SESSION['message_error'] = 'La extension del archivo es invalido';
    }
}

if (!empty($_GET['delete'])) {
    $carrusel = Carrusel::find($_GET['id_carrusel']);
    unlink('public/galeria/' . $carrusel->url);
    $carrusel->delete();
    $_SESSION['message_success'] = "Se elimino correctamente";
}


header("Location: " . $_SERVER["HTTP_REFERER"]);
