<?php

/**
 * Created by PhpStorm.
 * User: elporfirio
 * Date: 20/08/16
 * Time: 11:29 AM
 */

require_once('Conexion.php');

class Contador
{
    protected $conexion;
    protected $cantidad;

    public function __construct()
    {
        $oConexion = new Conexion();
        $this->conexion = $oConexion->getConexion();

        $this->obtenerContador();
    }

    public function obtenerContador(){
        #Consultar datos
        try{
            $query = 'SELECT cantidad FROM visitas WHERE id = 1';

            $stmt = $this->conexion->prepare($query);

            if($stmt->execute()){
                $this->cantidad = $stmt->fetchAll(PDO::FETCH_ASSOC);
            }
        } catch (PDOException $ex){
            echo "<strong>Error de ejecución: </strong>" . $ex->getMessage() . "<br>";
            die();
        }
    }

    public function actualizarContador(){
        try{
            $query = 'UPDATE visitas
                      SET `cantidad`= cantidad + 1
                      WHERE `id`= 1 ';

            $stmt = $this->conexion->prepare($query);

            if($stmt->execute()){
                $this->obtenerContador();
            }
        } catch (PDOException $ex){
            echo "<strong>Error de ejecución: </strong>" . $ex->getMessage() . "<br>";
            die();
        }
    }

    public function getCantidad(){
        return $this->cantidad[0]['cantidad'];
    }
}