<?php

/**
 * Created by PhpStorm.
 * User: elporfirio
 * Date: 20/08/16
 * Time: 12:06 PM
 */
class Registro
{

    protected $conexion;
    protected $registro;

    public function __construct()
    {
        $oConexion = new Conexion();
        $this->conexion = $oConexion->getConexion();
    }

    public function registrarVisita($ip){
        #Consultar datos
        try{
            $query = 'INSERT INTO registro_ip (`ip_visita`, `fecha`)
            VALUES (:ip, DATE(NOW()));';

            $stmt = $this->conexion->prepare($query);

            $stmt->bindParam(':ip', $ip);

            if($stmt->execute()){
                $this->registro = $this->conexion->lastInsertId();
            }
        } catch (PDOException $ex){
            echo "<strong>Error de ejecución: </strong>" . $ex->getMessage() . "<br>";
            die();
        }
    }

    public function verificarVisita($ip){
        #Consultar datos
        try{
            $query = 'SELECT * FROM registro_ip 
                      WHERE ip_visita = :ip';

            $stmt = $this->conexion->prepare($query);

            $stmt->bindParam(':ip', $ip);

            if($stmt->execute()){
                $this->registro = $stmt->fetchAll(PDO::FETCH_ASSOC);
            }
        } catch (PDOException $ex){
            echo "<strong>Error de ejecución: </strong>" . $ex->getMessage() . "<br>";
            die();
        }
    }

    public function obtenerRegistro(){
        return $this->registro;
    }

}