<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Solicitante extends Model
{
    use SoftDeletes;
    protected $table = 'solicitantes';

    protected $fillable = [
        'expediente_std',
    ];

    protected $attributes = [
        'fecha_revisado' => '0000-00-00 00:00:00',
        'deleted_at' => '0000-00-00 00:00:00'
    ];

    public function getFecha()
    {
        $newDate = date("Y/m/d", strtotime($this->created_at));
        return $newDate;
    }
    public function getHora()
    {
        $newHora = date("g:i A", strtotime($this->created_at));
        return $newHora;
    }
    public function getFechaRevidado()
    {
        $fecha_revisado = date("Y-m-d g:i A", strtotime($this->fecha_revisado));
        return $fecha_revisado;
    }

    public function getTipoPersona()
    {
        $item = Item::find($this->tipo_persona); 
        return $item->nombre;
    }
    public function getTipoDocumento()
    {
        $item = Item::find($this->tipo_documento); 
        return $item->nombre;
    }
    public function getProvincia()
    {
        $item = Item::find($this->provincia); 
        return $item->nombre;
    }
    public function getDistrito()
    {
        $item = Item::find($this->distrito); 
        return $item->nombre;
    }
    public function getAnexo()
    {
        $item = Item::find($this->anexo); 
        return $item->nombre;
    }
    public function getSeguimiento()
    {
        $item = Item::find($this->std_expediente); 
        return $item->nombre;
    }
    
}