<?php
require_once 'app/Libreria/Conexion_pdo.php';

$resultado = null;
$expediente_virtual = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $expediente_virtual = trim($_POST['expediente_virtual']);

    if (!ctype_digit($expediente_virtual)) {
        $resultado = ["type" => "danger", "msg" => "⚠️ Por favor, ingresa solo números."];
    } else {
        $conn = Conexion::getConexion();
        $stmt = $conn->prepare("SELECT expediente_std FROM solicitantes WHERE id = ?");
        $stmt->execute([$expediente_virtual]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res && !empty($res['expediente_std'])) {
            $resultado = [
                "type" => "success",
                "msg" => "✅ Su documento ingresó a la Municipalidad con el siguiente número de expediente:",
                "expediente" => htmlspecialchars($res['expediente_std'])
            ];
        } else {
            $resultado = ["type" => "warning", "msg" => "❌ No se encontró el número de expediente virtual ingresado."];
        }
    }
}
?>

<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="public/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="public/css/style_foter.css">
    <link rel="shortcut icon" href="public/dist_admin/img/apple-touch-icon.png">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.7.2/font/bootstrap-icons.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <title>Consulta Expediente</title>
</head>

<body>

    <header class="container-fluid bg-verdedark border">
        <nav class="container navbar  p-1 " style="flex-direction:column">
            <a class="navbar-brand p-0" href="#">
                <img src="public/galeria/logo_empresa.png" width="500" alt="" loading="lazy" style="padding-bottom: 10px;">
            </a>
            <div class="text-white">
            </div>
            <div class="align-self-center"></div>
        </nav>
    </header>

    <div class="container-fluid fondo-ok border mt-0 pt-2 pb-2">
        <div class="success-alert p-4 mx-auto mt-4 mb-4">
        <h3 class="mb-4 text-center" style="color:#007bff" >Consulta tu expediente físico</h3>

        <form method="POST" action="">
            <div class="form-group">
                 <label for="expediente_virtual">Número de expediente virtual:</label>
                <input type="text" name="expediente_virtual" style="font-size: 1.3rem" id="expediente_virtual" 
                        class="form-control" placeholder="Ej. 1634" required
                        pattern="[0-9]+" title="Solo se permiten números"
                        value="<?= htmlspecialchars($expediente_virtual) ?>">
            </div>
            <button type="submit" class="btn btn-primary btn-block">Buscar</button>
        </form>
        <?php if ($resultado): ?>
            <div class="alert alert-<?= $resultado['type'] ?> mt-4 text-center">
                <?php if ($resultado['type'] === 'success'): ?>
                    <h4><?= $resultado['msg'] ?></h4>
                     <div class="expediente-box"><?= $resultado['expediente'] ?></div> <br>
                     <p class=" mb-0 text-center size-text-device text-justify pl-3 pr-3 pt-1">Si desea realizar una
                     busqueda de su documento, presione el siguiente botón 👇</p>
                     
                <?php else: ?>
                <?= $resultado['msg'] ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>
            <br>
            <div class="highlight-box mb-2 bg-white">
                <div class="d-grid gap-2">
                    
                    <a class="btn btn-primary m-2 align-items-center d-flex justify-content-center" target="_blank"
                        href="http://181.176.14.2/st/cInterfaseUsuario_SITD/consultaTramite.php">
                        <p class="m-1 btn-consulta-mdm">
                            <span>Consultar Expediente de Mesa de Partes</span>
                            <span>-MDM-</span>
                        </p>
                        <p class="icon-consulta-mdm">
                            <i class="bi bi-file-earmark-binary ml-2"></i>
                        </p>
                    </a>
                </div>
            </div>
            <div class="d-grid gap-2 mt-3 mb-3" style="border-top: 2px solid rgba(192, 192, 192, 0.651);">
                <p class="mb-0 text-center mt-3" style="font-size: 20px;">Si desea regresar atras, presione el siguiente
                    botón</p>
                <a href="index.php" class="btn btn-outline-danger custom-btn-back mt-0 ml-2 mr-2 p-2">
                    <i class="bi bi-arrow-left-square mr-2"></i>
                    Regresar al Inicio
                </a>
            </div>
        </div>
    </div>

    <footer class="footer spad set-bg" data-setbg="images/footer-bg.png">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="footer__address text-center">
                        <ul>
                            <li>
                                <i class="fa fa-phone"></i>
                                <h4>Celular</h4>
                                <h6><a href="https://wa.me/51950866847" target="_blank"
                                        style="color: rgb(245, 238, 234);">950 866 847</a></h6>
                            </li>
                            <li>
                                <i class="fa-solid fa-globe"></i>
                                <h4>P&aacutegina Web</h4>
                                <h6><a href="https://www.gob.pe/munimazamari" target="_blank"
                                        style="color: rgb(245, 238, 234);">munimazamari.gob.pe</a>
                                </h6>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 col-md-6">
                    <div class="footer__social text-center">
                        <h2>Municipalidad Distrital de Mazamari</h2>
                        <div class="footer__social__links ">
                            <a href="https://www.facebook.com/MunicipalidadDistritalMazamariOficial"><i
                                    class="fa fa-facebook"></i></a>
                            <a href="https://www.youtube.com/channel/UCtnVfVb-x1_wQNJCwt_Bgng"><i
                                    class="fa-brands fa-youtube"></i></a>
                            <a href="https://www.instagram.com/muni_mazamari/"><i class="fa fa-instagram"></i></a>
                            <a href="https://www.tiktok.com/@municipalidad_mazamari?_t=8dE19ukegKb&_r=1"><i
                                    class="fa-brands fa-tiktok"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 offset-lg-1 col-md-6">
                    <div class="footer__newslatter text-center">
                        <h4>Hazme una consulta</h4>
                        <form action="https://wa.me/51950866847">
                            <input type="text" placeholder="Quiero hacer una consulta">
                            <button type="submit"><i class="fa-brands fa-whatsapp"></i></i></button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
            <div class="footer__copyright__text">
                <p>Copyright &copy;
                    <script>
                        document.write(new Date().getFullYear());
                    </script> Todos los derechos reservados | Municipalidad Distrital <i class="fa fa-heart"
                        aria-hidden="true"></i> <a href="https://www.gob.pe/munimazamari" target="_blank">Mazamari</a>
                </p>
            </div>
            <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
        </div>
    </footer>
    <!-- Optional JavaScript -->
    <!-- jQuery first, then Bootstrap JS -->
    <script src="public/js/jquery-3.5.1.min.js"></script>
    <script src="public/js/bootstrap.min.js"></script>
    <script src="public/js/main.js"></script>

    <script src="https://kit.fontawesome.com/84e760954d.js" crossorigin="anonymous"></script>
    <script>
        //window.history.replaceState( null, null, window.location.href );
    </script>
</body>

</html>











