<?php

/**psr-4 */
require_once "vendor/autoload.php";

/*coneccion */

use App\Libreria\Conexion;
use App\Models\Solicitante;
use App\Models\File;

$connecion = new Conexion();

$error = null;
$numero = 0;//enumerar los files
$file_enviados = array();
$directorio = "public/docs/";//donde se guardara los files
$numero_expediente = null;
$solicitantes = null;
/*
$tamaño_archivo1 = 0;
$tamaño_archivo2 = 0;
foreach ($_FILES['documentos']['tmp_name'] as $key => $tmp_name) {
    $tamaño_archivo1 += $_FILES['documentos']['size'][$key];
}
foreach ($_FILES['anexos']['tmp_name'] as $key => $tmp_name) {
    $tamaño_archivo2 += $_FILES['documentos']['size'][$key];
}
echo round($tamaño_archivo1 / 1048576, 2);
echo "<br>";
echo round($tamaño_archivo2 / 1048576, 2);
echo "<br>";
$suma = $tamaño_archivo1 + $tamaño_archivo2;
echo round($tamaño_archivo1 + $tamaño_archivo2, 2);
*/


$diaenvio = date('l');
$horaenvio = date('H');

/**Dia laborable */
if ($diaenvio != "Saturday" and $diaenvio != "Sunday") {

    /**Hora laborable */
    if ($horaenvio < '06' or $horaenvio > '18') {
        $loader = new \Twig\Loader\FilesystemLoader('public/views');
        $twig = new \Twig\Environment($loader, [
            'debug' => true,
            'cache' => false,
        ]);

        echo $twig->render('nolaborable.html');
        die();
    }
}


if (!empty($_POST) && isset($_POST)) {
    $dir = opendir($directorio); //Abrimos el directorio de destino
    $connecion->connection()->getPdo()->beginTransaction();
    try {
        
            $solicitantes = new Solicitante();
            $solicitantes->tipo_persona = $_POST['tipo_personas'];
            $solicitantes->documento = strtoupper($_POST['documento']);
            $solicitantes->razon_social = strtoupper($_POST['razon_social']);
            $solicitantes->apellido_paterno = strtoupper($_POST['apellido_paterno']);
            $solicitantes->apellido_materno = strtoupper($_POST['apellido_materno']);
            $solicitantes->nombres = strtoupper($_POST['nombre']);
            $solicitantes->telefono = $_POST['telefono'];
            $solicitantes->correo = $_POST['correo'];
            $solicitantes->direccion = $_POST['direccion'];
            $solicitantes->provincia = $_POST['provincia'];
            $solicitantes->distrito = $_POST['distrito'];
            $solicitantes->anexo = $_POST['anexo'] === 'all' ? null : $_POST['anexo'];
            $solicitantes->tipo_documento = $_POST['tipo_documento'];
            $solicitantes->numero_folio = $_POST['numero_folio'];
            $solicitantes->asunto = strtoupper($_POST['asunto']);
            $solicitantes->estado = 'pendiente';
            $solicitantes->save();
            $numero_expediente = $solicitantes->id . date('dmY');;
            $solicitantes->numero_expediente = $numero_expediente;
            $solicitantes->save();

            //Como el elemento es un arreglos utilizamos foreach para extraer todos los valores
            foreach ($_FILES["documentos"]['tmp_name'] as $key => $tmp_name) {
                //Validamos que el archivo exista
                if ($_FILES["documentos"]["name"][$key]) {
                    $filename = $solicitantes->id . '-documento' . $numero . '.pdf';
                    $source = $_FILES["documentos"]["tmp_name"][$key]; //Obtenemos un nombre temporal del archivo

                    //Validamos si la ruta de destino existe, en caso de no existir la creamos
                    if (!file_exists($directorio)) {
                        if(!mkdir($directorio, 0777)){
                            throw new Exception("No se pudo crear el directorio");
                        }
                    }

                    $target_path = $directorio . '/' . $filename; //Indicamos la ruta de destino, así como el nombre del archivo

                    //Movemos y validamos que el archivo se haya cargado correctamente
                    //El primer campo es el origen y el segundo el destino
                    if (move_uploaded_file($source, $target_path)) {
                        $file_enviados[$numero] = $filename;
                        $docs = new File();
                        $docs->url = $filename;
                        $docs->tipo = 'documentos';
                        $docs->solicitante_id = $solicitantes->id;
                        $docs->save();
                        $numero++;
                    } else {
                        throw new Exception("Error al subir los archivos");
                    } 
                    
                }

            }

        foreach ($_FILES["anexos"]['tmp_name'] as $key => $tmp_name) {
            //Validamos que el archivo exista
            if ($_FILES["anexos"]["name"][$key]) {
                $info = new SplFileInfo($_FILES['anexos']['name'][$key]);//obtenemos la extencion del archivo
                $filename = $solicitantes->id . '-anexo' . $numero . '.' . $info->getExtension();
                $source = $_FILES["anexos"]["tmp_name"][$key];

                //Validamos si la ruta de destino existe, en caso de no existir la creamos
                if (!file_exists($directorio)) {
                    if(!mkdir($directorio, 0777)){
                        throw new Exception("No se pudo crear el directorio");
                    }
                }

                $target_path = $directorio . '/' . $filename; //Indicamos la ruta de destino, así como el nombre del archivo

                //Movemos y validamos que el archivo se haya cargado correctamente
                //El primer campo es el origen y el segundo el destino
                if (move_uploaded_file($source, $target_path)) {
                    $file_enviados[$numero] = $filename;
                    $files = new File();
                    $files->url = $filename;
                    $files->tipo = 'anexos';
                    $files->solicitante_id = $solicitantes->id;
                    $files->save();
                    $numero++;
                } else {
                    throw new Exception("Error al subir los archivos");
                }
            }

            }

        $connecion->connection()->getPdo()->commit();
    } catch (\Throwable $th) {
        $connecion->connection()->getPdo()->rollBack();
        for ($i=0; $i < count($file_enviados); $i++) { 
            unlink($file_enviados[$i]);
        }
        $error = "Sucedio algo inesperado, Por favor vuelva a intentar mas tarde.";
        
        $file = './logs/app.log';
        // Open the file to get existing content
        $current = file_get_contents($file);
        // Append a new person to the file
        $current .= '[' . date('Y-m-d H:i:s') . '] app.ERROR: ' . $th->getMessage() . "\n";
        // Write the contents back to the file
        file_put_contents($file, $current);
    }finally{
        closedir($dir);
    }
}


$loader = new \Twig\Loader\FilesystemLoader('public/views');
$twig = new \Twig\Environment($loader, [
    'debug' => true,
    'cache' => false,
]);

echo $twig->render('ok.html', [
    'error' => $error,
    'solicitante' => $solicitantes
]);
