<?php

/**psr-4 */
require_once "vendor/autoload.php";
date_default_timezone_set('America/Lima');

use App\Libreria\Conexion; new Conexion();
use App\Models\Usuario;
use App\Models\Empresa;

require_once('session.php');

$usuario = Usuario::find($_SESSION['user']->id);
$empresa = Empresa::first();

$loader = new \Twig\Loader\FilesystemLoader('public/views');
$twig = new \Twig\Environment($loader, [
    'debug' => true,
    'cache' => false,
]);

$message_error = null;
$message_success = null;
if (isset($_SESSION['message_error'])) {
    $message_error = $_SESSION['message_error'];
    unset($_SESSION['message_error']);
}
if (isset($_SESSION['message_success'])) {
    $message_success = $_SESSION['message_success'];
    unset($_SESSION['message_success']);
}
echo $twig->render('perfil.html',[
    'usuario' => $usuario,
    'empresa' => $empresa,
    'message_error' => $message_error,
    'message_success' => $message_success,
    'user' => $_SESSION['user'],
    'privilegios' => $_SESSION['privilegios']
]);