<?php
require_once 'app/Libreria/Conexion_pdo.php';

$resultado = null;
$expediente_virtual = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $expediente_virtual = trim($_POST['expediente_virtual']);

    if (!ctype_digit($expediente_virtual)) {
        $resultado = ["type" => "danger", "msg" => "⚠️ Por favor, ingresa solo números."];
    } else {
        $conn = Conexion::getConexion();
        $stmt = $conn->prepare("SELECT expediente_std FROM solicitantes WHERE id = ?");
        $stmt->execute([$expediente_virtual]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res && !empty($res['expediente_std'])) {
            $resultado = [
                "type" => "success",
                "msg" => "✅ Tu número de expediente físico es:",
                "expediente" => htmlspecialchars($res['expediente_std'])
            ];
        } else {
            $resultado = ["type" => "warning", "msg" => "❌ No se encontró el número de expediente virtual ingresado."];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Consulta de Expediente</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <!-- Estilo personalizado -->
  <style>
    body {
      background: #e9f5ff;
      font-family: 'Segoe UI', sans-serif;
    }
    .consulta-box {
      background: white;
      border-radius: 10px;
      padding: 30px;
      max-width: 600px;
      margin: 80px auto;
      box-shadow: 0 0 20px rgba(0,0,0,0.1);
      border-top: 5px solid #007bff;
    }
    .btn-primary {
      background-color: #007bff;
      border-color: #007bff;
    }
    .btn-primary:hover {
      background-color: #0056b3;
      border-color: #004ca1;
    }
    h3 {
      color: #007bff;
    }
    .expediente-box {
      border: 3px solid #28a745;
      border-radius: 10px;
      padding: 15px;
      margin-top: 15px;
      background-color: #e6ffed;
      font-size: 2rem;
      font-weight: bold;
      color: #155724;
    }
  </style>
</head>
<body>

  <div class="consulta-box">
    <h3 class="mb-4 text-center">Consulta tu expediente físico</h3>

    <form method="POST" action="">
      <div class="form-group">
        <label for="expediente_virtual">Número de expediente virtual:</label>
        <input type="text" name="expediente_virtual" id="expediente_virtual" 
               class="form-control" placeholder="Ej. 1634" required
               pattern="[0-9]+" title="Solo se permiten números"
               value="<?= htmlspecialchars($expediente_virtual) ?>">
      </div>
      <button type="submit" class="btn btn-primary btn-block">Buscar</button>
    </form>

    <?php if ($resultado): ?>
      <div class="alert alert-<?= $resultado['type'] ?> mt-4 text-center">
        <?php if ($resultado['type'] === 'success'): ?>
          <h4><?= $resultado['msg'] ?></h4>
          <div class="expediente-box"><?= $resultado['expediente'] ?></div>
        <?php else: ?>
          <?= $resultado['msg'] ?>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

</body>
</html>
