$(document).ready(function () {

    $('#solicitante-form').submit(function (event) {
        var bandera = true;
        if($("#provincia").val() == "all"){
            bandera = false;
        };
        if($("#distrito").val() == "all"){
            bandera = false;
        };
        if($("#provincia").val() == "all"){
            bandera = false;
        };
        
        if(bandera){
            console.log('sumbit1');
            $('#btn-enviodocumentos').attr('disabled','true');
            $('#btn-enviodocumentos').text('Enviando...');
            $('#enviodocumentos-estatus').removeClass('d-none');
        }else{
            event.preventDefault();
            $("#mensage-form").text("* Seleccione provincia, distrito y su centro poblado");
        }
    });

    $("#btn-imprimir-recibidos").click(function () {
        var url = 'ventana_recibidos.php?fecha_de=' + $("#fecha_de").val() + '&fecha_asta=' + $("#fecha_asta").val();
        window.open(url, "ventana1", "width=900,height=500,scrollbars=NO")
    });
    $("#btn-imprimir-reporte").click(function () {
        var fecha_de = "&fecha_de=" + $("#fecha_de").val();
        var fecha_asta = "&fecha_asta=" + $("#fecha_asta").val();
        var tipo_persona = "&tipo_persona=" + $("#tipo_persona").val();
        var tipo_documento = "&tipo_documento=" + $("#tipo_documento").val();
        var provincia = "&provincia=" + $("#provincia").val();
        var distrito = "&distrito=" + $("#distrito").val();
        var anexo = "&anexo=" + $("#anexo").val();

        var url = 'ventana_reporte.php?' + fecha_de + fecha_asta + tipo_persona + tipo_documento + provincia + distrito + anexo;
        window.open(url, "ventana1", "width=900,height=500,scrollbars=NO")
    });

    $("#btn-imprimir").click(function () {
        window.print();
        window.onbeforeprint = function () {
            $('#btn-imprimir').addClass('d-none');
        };
        window.onafterprint = function () {
            $('#btn-imprimir').removeClass('d-none');
        };

    })

    $('#file_documentos').change(function () {
        var fileSize = 0;
        for (let index = 0; index < this.files.length; index++) {
            var file = this.files[index];

            fileSize += file.size;
            var fileName = file.name;
            var ext = fileName.split('.').pop().toLowerCase();

            switch (ext) {
                case 'pdf':
                    break;
                default:
                    alert('El archivo no tiene la extensión adecuada');
                    this.value = ''; // reset del valor
                    file.name = '';
                    break;
            }
        }
        $('#tamanoArchivo_documentos').text(Math.round(fileSize / 1048576 * 100) / 100 + " MB");

    });
    $('#file_anexos').change(function () {
        var fileSize = 0;
        for (let index = 0; index < this.files.length; index++) {
            var file = this.files[index];

            fileSize += file.size;
            var fileName = file.name;
            var ext = fileName.split('.').pop().toLowerCase();

            switch (ext) {
                case 'pdf':
                    break;
                case 'docx':
                    break;
                case 'jpg':
                    break;
                case 'jpeg':
                    break;
                case 'png':
                    break;
                default:
                    alert('El archivo no tiene la extensión adecuada');
                    this.value = ''; // reset del valor
                    file.name = '';
                    break;
            }
        }
        $('#tamanoArchivo_anexos').text(Math.round(fileSize / 1048576 * 100) / 100 + " MB");
    })


    cambioTipoPersona($('#tipo_personas').val());//para ocultar ruc y mostrar
    $('#tipo_personas').change(function (e) {
        cambioTipoPersona($(this).val());
    });

    $('#btn-consultareniecdni').on('click', function (e) {
        if (validardnienvio($('#documentodni').val())) {
            consultaDniReniec($('#documentodni').val())
        }

    })
    $('#btn-consultareniecruc').on('click', function (e) {
        if (validarrucenvio($('#documentoruc').val())) {
            consultaRucReniec($('#documentoruc').val())
        }
    })

    function validardnienvio(dni) {
        if (dni.length != 8) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON RENIEC');
            $('#mensage-modalj').text('DNI no encontrado en los registros de la reniec');
            return false;
        }
        if (isNaN(dni)) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON RENIEC');
            $('#mensage-modalj').text('DNI no encontrado en los registros de la reniec');
            return false;
        }
        return true;
    }
    function validarrucenvio(ruc) {
        if (ruc.length != 11) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
            $('#mensage-modalj').text('RUC no encontrado en los registos de la SUNAT');
            return false;
        }
        if (isNaN(ruc)) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
            $('#mensage-modalj').text('RUC no encontrado en los registro de la SUNAT');
            return false;
        }
        return true;
    }


    var provincia = $('#provincia').val();
    var distrito = null;
    var anexo = null;
    var act = null;
    
    var query = window.location.search.substring(1);
    var vars = query.split("&");
    var banderaselect = true;
    if (vars.length > 1) {
        var banderaselect = false;
    }

    actualizar('.distrito_option', provincia);
    actualizar('.anexo_option', act);

    function actualizar(tabla, padre) {
        
        $(tabla).each(function () {
            if ($(this).attr('padre') == parseInt(padre)) {
                $(this).removeClass('d-none');

            } else {
                $(this).addClass('d-none');
            }
        });
    }

    $('#provincia').on('change', function () {
        actualizar('.distrito_option', $('#provincia').val());
        actualizar('.anexo_option', act);
        
        $("#distrito").val('all');
        $("#anexo").val('all');
    });
    $('#distrito').on('change', function () {
        actualizar('.anexo_option', $('#distrito').val());
        $("#anexo").val('all');
    });


    function getLugares(lugar, provincia) {
        var respuesta = null;
        $.ajax({
            method: "POST",
            url: "getLugares.php",
            data: { tabla: lugar },
            dataType: "json"
        }).done(function (msg) {
            console.log('datos obtenidos correctamente');
            respuesta = msg;
        });

        return respuesta;
    }

    function cambioTipoPersona(estado) {
        /* (1) -> ciudadano, (2) -> persona juridica */
        if (estado == 1) {
            $('#control-documentoruc').addClass('d-none');
            $('#control-razonsocial').addClass('d-none');
            $('#razon_social').removeAttr('required');
            $('#documentoruc').removeAttr('required');
        } else if (estado == 2) {
            $('#control-documentoruc').removeClass('d-none');
            $('#razon_social').attr('required', 'true');
            $('#control-razonsocial').removeClass('d-none');
            $('#documentoruc').attr('required', 'true');
        }
    }


    // funcion alterna a la anterior por un fallo de consulta
    function consultaDniReniec(numero) {
        $.ajax({
            method: 'GET',
            url: "https://apiperu.dev/api/dni/" + numero,
            dataType: 'json',
            headers: {
                "Authorization":"Bearer b2170dc7bbee5b60a4e6e23519f10c52e996ada5fbb17907eb29cb1d892accc7"
            },
            beforeSend: function (xhr) {
                $('#btn-consultareniecdni').attr('disabled', 'true');
            }
        }).done(function (response) {
            if (response.success) {
                $('#apellido_paterno').val(response.data.apellido_paterno);
                $('#apellido_materno').val(response.data.apellido_materno);
                $('#nombre').val(response.data.nombres);
            }else{
                $('#exampleModal').modal('show');
                $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
                $('#mensage-modalj').text('DNI no encontrado en los registos de la SUNAT');
                
                $('#apellido_paterno').val("");
                $('#apellido_materno').val("");
                $('#nombre').val("");
            }
        }).fail(function (error) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
            $('#mensage-modalj').text('DNI no encontrado en los registos de la SUNAT');
        }).always(function () {
            $('#btn-consultareniecdni').removeAttr('disabled');
        });
    }

    /*function consultaDniReniec(numero) {
        $.ajax({
            method: 'GET',
            url: "https://dniruc.apisperu.com/api/v1/dni/" + numero + "?token=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImZsb3Jlc21lemFqYW1lczE5OTlAb3V0bG9vay5jb20ifQ.nLxqr0yP44cDZefPtBS7cBta_jJDbZXB6SmQrHtDseI",
            beforeSend: function (xhr) {
                $('#btn-consultareniecdni').attr('disabled', 'true');
            }
        }).done(function (response) {
            console.log(response.apellidoMaterno);
            if (response.nombres == "") {
                $('#exampleModal').modal('show');
                $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
                $('#mensage-modalj').text('DNI no encontrado en los registos de la SUNAT');
            }
            $('#apellido_paterno').val(response.apellidoPaterno);
            $('#apellido_materno').val(response.apellidoMaterno);
            $('#nombre').val(response.nombres);
        }).fail(function (error) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
            $('#mensage-modalj').text('DNI no encontrado en los registos de la SUNAT');
        }).always(function () {
            $('#btn-consultareniecdni').removeAttr('disabled');
        });
    }*/
    function consultaRucReniec(numero) {
        $.ajax({
            method: 'GET',
            url: "https://dniruc.apisperu.com/api/v1/ruc/" + numero + "?token=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImZsb3Jlc21lemFqYW1lczE5OTlAb3V0bG9vay5jb20ifQ.nLxqr0yP44cDZefPtBS7cBta_jJDbZXB6SmQrHtDseI",
            beforeSend: function (xhr) {
                $('#btn-consultareniecruc').attr('disabled', 'true');
            }
        }).done(function (response) {
            $('#razon_social').val(response.razonSocial);
            $('#direccion').val(response.direccion);
        }).fail(function (error) {
            $('#exampleModal').modal('show');
            $('#titulo-modalj').text('SINCRONIZACION CON SUNAT');
            $('#mensage-modalj').text('RUC no encontrado en los registos de la SUNAT');
        }).always(function () {
            $('#btn-consultareniecruc').removeAttr('disabled', 'true');
        });
    }




    /**modalj */
    $('#boton-cerrar-modalj').click(function () {
        $('#modalj').addClass('d-none');
    });

});//fin ready