<?php

/**psr-4 */
require_once "vendor/autoload.php";
date_default_timezone_set('America/Lima');

use App\Libreria\Conexion;

new Conexion();

use App\Models\Solicitante;
use App\Models\Item;
use App\Models\Empresa;

require_once('session.php');


$tipo_personas = Item::where('grupo_id', '=', 1)->get();
$provincias = Item::where('grupo_id', '=', 2)->get();
$distritos = Item::where('grupo_id', '=', 3)->get();
$anexos = Item::where('grupo_id', '=', 4)->get();
$tipo_documentos = Item::where('grupo_id', '=', 5)->get();
$empresa = Empresa::first();

$fecha_de = date('Y/m/d', strtotime('2020/05/01'));
$fecha_asta = date("Y/m/d");
$tipo_persona = 'all';
$tipo_documento = 'all';
$provincia = 'all';
$distrito = 'all';
$anexo = 'all';

if (!empty($_GET['fecha_de'])) {
    $fecha_de = date("Y/m/d", strtotime($_GET['fecha_de']));
}
if (!empty($_GET['fecha_asta'])) {
    $fecha_asta = date("Y/m/d", strtotime($_GET['fecha_asta']));
}
if (!empty($_GET['tipo_persona'])) {
    $tipo_persona = $_GET['tipo_persona'];
}
if (!empty($_GET['tipo_documento'])) {
    $tipo_documento = $_GET['tipo_documento'];
}
if (!empty($_GET['provincia'])) {
    $provincia = $_GET['provincia'];
}
if (!empty($_GET['distrito'])) {
    $distrito = $_GET['distrito'];
}
if (!empty($_GET['anexo'])) {
    $anexo = $_GET['anexo'];
}


$solicitantes = null;


if ($tipo_persona == 'all' and $tipo_documento == 'all') {
    if ($provincia == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($distrito == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('provincia', $provincia)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($anexo == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->orderBy('id', 'desc')
            ->get();
    } else {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->where('anexo', $anexo)
            ->orderBy('id', 'desc')
            ->get();
    }
} else if ($tipo_persona == 'all' and $tipo_documento != 'all') {
    if ($provincia == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_documento', $tipo_documento)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($distrito == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($anexo == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->orderBy('id', 'desc')
            ->get();
    } else {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->where('anexo', $anexo)
            ->orderBy('id', 'desc')
            ->get();
    }
} else if ($tipo_persona != 'all' and $tipo_documento == 'all') {
    if ($provincia == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($distrito == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('provincia', $provincia)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($anexo == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->orderBy('id', 'desc')
            ->get();
    } else {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->where('anexo', $anexo)
            ->orderBy('id', 'desc')
            ->get();
    }
} else {
    if ($provincia == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('tipo_documento', $tipo_documento)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($distrito == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->orderBy('id', 'desc')
            ->get();
    } else if ($anexo == 'all') {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->orderBy('id', 'desc')
            ->get();
    } else {
        $solicitantes = Solicitante::whereDate('created_at', '>=', $fecha_de)
            ->whereDate('created_at', '<=', $fecha_asta)
            ->where('tipo_persona', $tipo_persona)
            ->where('tipo_documento', $tipo_documento)
            ->where('provincia', $provincia)
            ->where('distrito', $distrito)
            ->where('anexo', $anexo)
            ->orderBy('id', 'desc')
            ->get();
    }
}


$loader = new \Twig\Loader\FilesystemLoader('public/views');
$twig = new \Twig\Environment($loader, [
    'debug' => true,
    'cache' => false,
]);

echo $twig->render('reporte.html', [
    'solicitantes' => $solicitantes,
    'empresa' => $empresa,
    'fecha_de' => date("Y-m-d", strtotime($fecha_de)),
    'fecha_asta' => date("Y-m-d", strtotime($fecha_asta)),
    'tipo_personas' => $tipo_personas,
    'tipo_documentos' => $tipo_documentos,
    'provincias' => $provincias,
    'distritos' => $distritos,
    'anexos' => $anexos,
    'stipo_persona' => $tipo_persona,
    'stipo_documento' => $tipo_documento,
    'sprovincia' => $provincia,
    'sdistrito' => $distrito,
    'sanexo' => $anexo,
    'user' => $_SESSION['user'],
    'privilegios' => $_SESSION['privilegios']
]);
