<?php

/**psr-4 */
require_once "vendor/autoload.php";

use App\Libreria\Conexion;
use App\Models\Usuario;
use App\Models\Empresa;
use App\Models\Nivel;
new Conexion();

require_once('session.php');
$count = 0;
foreach ($_SESSION['privilegios'] as $key) {
    if ($key->nombre == "usuarios") {
        $count++;
    }
}
if ($count == 0) {
    echo "acceso denegado";
    die();
}

$usuarios = Usuario::select('usuarios.id','usuarios.nombre','usuarios.cargo','usuarios.nick','nivel.nombre as nivel')
->join('nivel','usuarios.nivel','=','nivel.id')
->orderBy('usuarios.id','desc')
->get();
$empresa = Empresa::first();
$niveles = Nivel::all();

$loader = new \Twig\Loader\FilesystemLoader('public/views');
$twig = new \Twig\Environment($loader, [
    'debug' => true,
    'cache' => false,
]);

$message_error = null;
$message_success = null;
if (isset($_SESSION['message_error'])) {
    $message_error = $_SESSION['message_error'];
    unset($_SESSION['message_error']);
}
if (isset($_SESSION['message_success'])) {
    $message_success = $_SESSION['message_success'];
    unset($_SESSION['message_success']);
}
echo $twig->render('soporte_usuario.html',[
    'usuarios' => $usuarios,
    'niveles' => $niveles,
    'message_error' => $message_error,
    'message_success' => $message_success,
    'empresa' => $empresa,
    'user' => $_SESSION['user'],
    'privilegios' => $_SESSION['privilegios']
]);