<?php

require_once "vendor/autoload.php";

use App\Libreria\Conexion; new Conexion();
use App\Models\Solicitante;
use App\Models\Empresa;

require_once('session.php');
$count = 0;
foreach ($_SESSION['privilegios'] as $key) {
    if ($key->nombre == "recibidos") {
        $count++;
    }
}
if ($count == 0) {
    echo "acceso denegado";
    die();
}

$fecha_de = date('Y/m/d', strtotime('2023/01/01'));
$fecha_asta = date("Y/m/d");


if (!empty($_GET['fecha_de'])) {
    $fecha_de = date("Y/m/d", strtotime($_GET['fecha_de']));
}
if (!empty($_GET['fecha_asta'])) {
    $fecha_asta = date("Y/m/d", strtotime($_GET['fecha_asta']));
}

$solicitantes = Solicitante::whereDate('created_at','>=',$fecha_de)
->whereDate('created_at','<=',$fecha_asta)
->orderBy('id','desc')
->get();
$empresa = Empresa::first();


$loader = new \Twig\Loader\FilesystemLoader('public/views');
$twig = new \Twig\Environment($loader, [
    'debug' => true,
    'cache' => false,
]);

echo $twig->render('ventana_recibidos.html',[
    'solicitantes' => $solicitantes,
    'empresa' => $empresa,
    'fecha_de' => date("Y-m-d", strtotime($fecha_de)),
    'fecha_asta' => date("Y-m-d", strtotime($fecha_asta)),
    'fecha' => date('d/m/Y'),
    'hora' => date('H:i:s'),
    'user' => $_SESSION['user'],
    'privilegios' => $_SESSION['privilegios']
]);